<?= view('layout/header') ?>

<style>
    .biodata-hero {
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
        padding: 50px 30px;
        border-radius: 30px;
        margin-bottom: 50px;
        position: relative;
        overflow: hidden;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }

    .biodata-hero::before {
        content: '👤';
        position: absolute;
        font-size: 15rem;
        opacity: 0.05;
        right: -50px;
        top: -50px;
        animation: float-emoji 6s ease-in-out infinite;
    }

    @keyframes float-emoji {
        0%, 100% { transform: translateY(0) rotate(0deg); }
        50% { transform: translateY(-20px) rotate(10deg); }
    }

    .hero-title {
        font-size: 3rem;
        font-weight: 900;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 10px;
        display: inline-flex;
        align-items: center;
        gap: 15px;
    }

    .hero-icon {
        font-size: 3rem;
        animation: pulse-icon 2s ease-in-out infinite;
    }

    @keyframes pulse-icon {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.1); }
    }

    .hero-subtitle {
        color: rgba(255, 255, 255, 0.6);
        font-size: 1.1rem;
        font-weight: 300;
    }

    .profile-card {
        background: rgba(255, 255, 255, 0.03);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 30px;
        overflow: hidden;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        animation: fadeInUp 0.6s ease;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .profile-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 60px 40px 40px 40px;
        position: relative;
        overflow: hidden;
    }

    .profile-header::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
        animation: rotate-gradient 15s linear infinite;
    }

    @keyframes rotate-gradient {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .photo-wrapper {
        position: relative;
        display: inline-block;
        margin-bottom: 25px;
    }

    .profile-photo {
        width: 180px;
        height: 180px;
        border-radius: 50%;
        border: 6px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4);
        object-fit: cover;
        position: relative;
        z-index: 2;
        animation: photo-float 3s ease-in-out infinite;
    }

    @keyframes photo-float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-10px); }
    }

    .photo-wrapper::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 200px;
        height: 200px;
        border-radius: 50%;
        background: linear-gradient(135deg, rgba(240, 147, 251, 0.3), rgba(245, 87, 108, 0.3));
        animation: pulse-ring 2s ease-in-out infinite;
        z-index: 1;
    }

    @keyframes pulse-ring {
        0%, 100% {
            transform: translate(-50%, -50%) scale(1);
            opacity: 1;
        }
        50% {
            transform: translate(-50%, -50%) scale(1.1);
            opacity: 0.7;
        }
    }

    .profile-name {
        font-size: 2.2rem;
        font-weight: 800;
        color: white;
        margin: 0;
        text-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        position: relative;
        z-index: 2;
    }

    .profile-nim {
        display: inline-block;
        background: rgba(255, 255, 255, 0.2);
        padding: 8px 20px;
        border-radius: 20px;
        color: white;
        font-weight: 600;
        font-size: 0.95rem;
        margin-top: 15px;
        backdrop-filter: blur(10px);
        position: relative;
        z-index: 2;
    }

    .profile-body {
        padding: 50px 40px;
    }

    .info-item {
        background: rgba(255, 255, 255, 0.02);
        border: 1px solid rgba(255, 255, 255, 0.08);
        border-radius: 20px;
        padding: 25px;
        margin-bottom: 20px;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .info-item::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #667eea, #764ba2);
        transform: scaleY(0);
        transition: transform 0.3s ease;
    }

    .info-item:hover {
        background: rgba(255, 255, 255, 0.05);
        border-color: rgba(102, 126, 234, 0.3);
        transform: translateX(5px);
    }

    .info-item:hover::before {
        transform: scaleY(1);
    }

    .info-label {
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 0.9rem;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.5);
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 10px;
    }

    .info-icon {
        font-size: 1.3rem;
        filter: grayscale(1);
        opacity: 0.6;
    }

    .info-value {
        font-size: 1.15rem;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.9);
        padding-left: 35px;
    }

    .empty-state {
        text-align: center;
        padding: 80px 40px;
        background: rgba(255, 255, 255, 0.03);
        border-radius: 25px;
        border: 2px dashed rgba(255, 255, 255, 0.1);
    }

    .empty-icon {
        font-size: 5rem;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .empty-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: rgba(255, 255, 255, 0.7);
        margin-bottom: 10px;
    }

    .empty-text {
        color: rgba(255, 255, 255, 0.5);
        font-size: 1rem;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        color: rgba(255, 255, 255, 0.8);
        padding: 14px 30px;
        border-radius: 25px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        margin-top: 30px;
    }

    .back-button:hover {
        background: rgba(255, 255, 255, 0.1);
        border-color: rgba(102, 126, 234, 0.5);
        color: white;
        transform: translateX(-5px);
    }

    .back-icon {
        font-size: 1.2rem;
        transition: transform 0.3s ease;
    }

    .back-button:hover .back-icon {
        transform: translateX(-5px);
    }

    @media (max-width: 768px) {
        .hero-title {
            font-size: 2rem;
        }

        .hero-icon {
            font-size: 2rem;
        }

        .biodata-hero {
            padding: 30px 20px;
        }

        .profile-header {
            padding: 40px 25px 30px 25px;
        }

        .profile-photo {
            width: 140px;
            height: 140px;
        }

        .photo-wrapper::before {
            width: 160px;
            height: 160px;
        }

        .profile-name {
            font-size: 1.6rem;
        }

        .profile-body {
            padding: 30px 25px;
        }

        .info-item {
            padding: 20px;
        }

        .info-value {
            font-size: 1rem;
        }
    }
</style>

<div class="biodata-hero">
    <h1 class="hero-title">
        Biodata Pribadi
    </h1>
    <p class="hero-subtitle">Informasi lengkap tentang profil dan data diri</p>
</div>

<?php if ($biodata): ?>
    <div class="profile-card">
        <div class="profile-header text-center">
            <div class="photo-wrapper">
                <?php if (!empty($biodata['foto'])): ?>
                    <img src="<?= base_url('uploads/biodata/' . $biodata['foto']) ?>"
                        class="profile-photo"
                        alt="Foto Profile">
                <?php else: ?>
                    <img src="https://ui-avatars.com/api/?name=<?= urlencode($biodata['nama']) ?>&size=180&background=667eea&color=fff&bold=true"
                        class="profile-photo"
                        alt="Foto Profile">
                <?php endif; ?>
            </div>
            <h2 class="profile-name"><?= esc($biodata['nama']) ?></h2>
            <div class="profile-nim">NIM: <?= esc($biodata['nim']) ?></div>
        </div>

        <div class="profile-body">
            <div class="info-item">
                <div class="info-label">
                    <span class="info-icon">⚧️</span>
                    <span>Jenis Kelamin</span>
                </div>
                <div class="info-value"><?= esc($biodata['jenis_kelamin']) ?></div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <span class="info-icon">🎂</span>
                    <span>Tempat, Tanggal Lahir</span>
                </div>
                <div class="info-value">
                    <?= esc($biodata['tempat_lahir']) ?>, <?= esc($biodata['tanggal_lahir']) ?>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <span class="info-icon">📍</span>
                    <span>Alamat</span>
                </div>
                <div class="info-value"><?= esc($biodata['alamat']) ?></div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <span class="info-icon">📱</span>
                    <span>No HP</span>
                </div>
                <div class="info-value"><?= esc($biodata['no_hp']) ?></div>
            </div>

            <div class="info-item">
                <div class="info-label">
                    <span class="info-icon">📧</span>
                    <span>Email</span>
                </div>
                <div class="info-value"><?= esc($biodata['email']) ?></div>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="empty-state">
        <div class="empty-icon">📭</div>
        <h3 class="empty-title">Data Tidak Tersedia</h3>
        <p class="empty-text">Biodata belum diinput atau belum tersedia saat ini</p>
    </div>
<?php endif; ?>

<div class="text-center">
    <a href="<?= base_url('/') ?>" class="back-button">
        <span class="back-icon">←</span>
        <span>Kembali ke Home</span>
    </a>
</div>

<?= view('layout/footer') ?>